' Check if tool has SPEC EUV, COM EUV or TBA in production hierarchy
On Error Resume Next

' Set scripting mode to true
Set WSHShell = CreateObject("WScript.Shell")

' Disable SAP GUI scripting warnings in registry
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAttach", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnConnection", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAllowListRequired", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\UseAllowList", 0, "REG_DWORD"

' Get material number (12NC) from command line argument
materialNumber = WScript.Arguments.Item(0)

' Declare log file object and path
Dim logFile, logFilePath

' Initialize log file if path is provided
If WScript.Arguments.Count > 1 Then
    logFilePath = WScript.Arguments.Item(1)
    ' Try to open the log file in append mode (8)
    On Error Resume Next
    Set fso = CreateObject("Scripting.FileSystemObject")
    Set logFile = fso.OpenTextFile(logFilePath, 8, True)
    
    If Err.Number <> 0 Then
        WScript.Echo "ERROR: Could not open log file: " & Err.Description
        Err.Clear
        Set logFile = Nothing
    Else
        ' Log script start
        LogToFile "========================================="
        LogToFile "Cleaning Check Script Started at " & Now
        LogToFile "Script: " & WScript.ScriptName
        LogToFile "Material Number: " & materialNumber
        LogToFile "========================================="
    End If
End If

' Function to log message to file
Sub LogToFile(message)
    On Error Resume Next
    If Not logFile Is Nothing Then
        logFile.WriteLine Now & " - [" & WScript.ScriptName & "] - " & message
    End If
End Sub

' Function to log message to both console and file
Sub LogMessage(message)
    WScript.Echo message
    LogToFile message
End Sub

' SAP connection code
If Not IsObject(application) Then
   Set SapGuiAuto = GetObject("SAPGUI")
   If Err.Number <> 0 Then
       LogMessage "Error getting SAPGUI: " & Err.Description
       WScript.Echo "ERROR: Cannot connect to SAP - " & Err.Description
       WScript.Quit 1
   End If
   Set application = SapGuiAuto.GetScriptingEngine
End If

If Not IsObject(connection) Then
   Set connection = application.Children(0)
End If

If Not IsObject(session) Then
   Set session = connection.Children(0)
End If

If IsObject(WScript) Then
   WScript.ConnectObject session, "on"
   WScript.ConnectObject application, "on"
End If

' Handle security dialog if needed
Sub HandleSecurityDialog()
    Dim shell, timeout, dialogFound
    Set shell = CreateObject("WScript.Shell")
    timeout = 0
    dialogFound = False
    
    Do While timeout < 10
        If shell.AppActivate("SAP GUI Security") Then
            WScript.Sleep 500
            shell.SendKeys " "  ' Press space to check "Remember my decision"
            WScript.Sleep 200
            shell.SendKeys "{ENTER}"  ' Press Enter to click Allow
            dialogFound = True
            Exit Do
        End If
        WScript.Sleep 500
        timeout = timeout + 1
    Loop
End Sub

' Call security dialog handler
HandleSecurityDialog()

' Execute the SAP commands to check production hierarchy
On Error Resume Next
LogMessage "Checking production hierarchy for material: " & materialNumber

session.findById("wnd[0]").maximize
session.findById("wnd[0]/tbar[0]/okcd").text = "ZSTS"
session.findById("wnd[0]").sendVKey 0

' Check if we need to handle error after opening transaction
If Err.Number <> 0 Then
    LogMessage "Error opening ZSTS transaction: " & Err.Description
    WScript.Echo "ERROR: " & Err.Description
    WScript.Quit 1
End If

' Select options and enter material number
session.findById("wnd[0]/usr/chkB_PRDHR").selected = true
session.findById("wnd[0]/usr/ctxtS_MATNR-LOW").text = materialNumber
session.findById("wnd[0]/usr/ctxtS_PLANT-LOW").text = "NL10"
session.findById("wnd[0]/usr/ctxtP_SALES").text = "NL01"
session.findById("wnd[0]/usr/ctxtS_VTWEG-LOW").text = "01"
session.findById("wnd[0]/usr/chkB_PRDHR").setFocus
session.findById("wnd[0]/tbar[1]/btn[8]").press

' Check if we have results
If Err.Number <> 0 Then
    LogMessage "Error executing search: " & Err.Description
    WScript.Echo "ERROR: " & Err.Description
    WScript.Quit 1
End If

' Look for the production hierarchy info column
' We need to find SPEC EUV, COM EUV or TBA
Dim productHierarchy, needsCleaning
needsCleaning = False

' Get the grid control
On Error Resume Next
Set grid = session.findById("wnd[0]/usr/cntlGRID1/shellcont/shell")

If Err.Number <> 0 Then
    LogMessage "Error accessing grid: " & Err.Description
    WScript.Echo "ERROR: Grid not found - " & Err.Description
    WScript.Quit 1
End If

' In sap-script-check-cleaning.vbs, update the column handling
LogMessage "Grid accessed successfully with " & grid.RowCount & " rows and " & grid.ColumnCount & " columns"

' Log available column names
LogMessage "Available columns: "
Dim i, colNames, prodHierarchyColumn
colNames = ""
prodHierarchyColumn = "PRDHA"  ' Default column name

For i = 0 To grid.ColumnCount - 1
    Dim colName
    colName = grid.GetColumnName(i)
    colNames = colNames & colName & " | "
    
    ' Try to find the production hierarchy column based on common names
    If InStr(1, colName, "PRDH", vbTextCompare) > 0 Or _
       InStr(1, colName, "HIER", vbTextCompare) > 0 Then
        prodHierarchyColumn = colName
        LogMessage "Found likely production hierarchy column: " & prodHierarchyColumn
    End If
Next
LogMessage "All columns: " & colNames

' Use the identified column or fall back to default
If grid.RowCount > 0 Then
    ' Try to get the value using the identified column
    On Error Resume Next
    productHierarchy = grid.GetCellValue(0, prodHierarchyColumn)
    
    If Err.Number <> 0 Then
        LogMessage "Error accessing column " & prodHierarchyColumn & ": " & Err.Description
        Err.Clear
        ' Try alternative column names
        For Each possibleCol In Array("PRDHA", "PRODH", "HIERARCHY", "HIERTX")
            On Error Resume Next
            productHierarchy = grid.GetCellValue(0, possibleCol)
            If Err.Number = 0 Then
                LogMessage "Successfully accessed column: " & possibleCol
                Exit For
            End If
            Err.Clear
        Next
    End If
    
    ' After the column detection code, add this as a fallback if no data is found
    If productHierarchy = "" Then
        ' Try using the selection approach instead
        On Error Resume Next
        session.findById("wnd[0]/usr/cntlGRID1/shellcont/shell").currentCellColumn = prodHierarchyColumn
        session.findById("wnd[0]/usr/cntlGRID1/shellcont/shell").selectedRows = "0"
        WScript.Sleep 500
        
        ' Now try to get the selected cell value
        productHierarchy = session.findById("wnd[0]/usr/cntlGRID1/shellcont/shell").getCellValue(0, prodHierarchyColumn)
        LogMessage "Retrieved value using selection method: " & productHierarchy
    End If
    
    LogMessage "Found production hierarchy: " & productHierarchy
    
    ' Check for specific values
    If InStr(1, productHierarchy, "SPEC EUV", vbTextCompare) > 0 Or _
       InStr(1, productHierarchy, "COM EUV", vbTextCompare) > 0 Or _
       InStr(1, productHierarchy, "TBA", vbTextCompare) > 0 Then
        needsCleaning = True
        LogMessage "Found EUV/TBA indicator in hierarchy: " & productHierarchy
    End If
Else
    LogMessage "No rows found for material"
End If

' Check specifically for SPEC EUV, COM EUV, or TBA in the hierarchy
' This is the final output section - make sure it's clear and only appears once
If InStr(1, productHierarchy, "SPEC EUV", vbTextCompare) > 0 Or _
   InStr(1, productHierarchy, "COM EUV", vbTextCompare) > 0 Or _
   InStr(1, productHierarchy, "TBA", vbTextCompare) > 0 Then
    LogMessage "Found SPEC EUV/COM EUV/TBA in hierarchy: " & productHierarchy
    WScript.Echo "EUV-HIERARCHY:" & productHierarchy
Else
    LogMessage "No SPEC EUV/COM EUV/TBA found in hierarchy: " & productHierarchy
    WScript.Echo "NO-EUV-HIERARCHY:" & productHierarchy
End If

' Navigate back to exit the transaction
session.findById("wnd[0]").sendVKey 3
session.findById("wnd[0]").sendVKey 3

' Close log file before exit
Sub CloseLogFile()
    On Error Resume Next
    If Not logFile Is Nothing Then
        LogToFile "Script ended at " & Now
        LogToFile "========================================="
        logFile.Close
        Set logFile = Nothing
    End If
End Sub

CloseLogFile()